''Demo for Digital Lighting Controller Slave
''Outputting serial data giving test patterns
''Connect DATA+ to 3.3V and DATA- to pin 9

OPTION AUTORUN ON

Const DLC_TX_PIN =9

'' to hold data
Dim B%(64) As INTEGER
DIM T%(6)
T%(1)=85
T%(2)=170
T%(3)=255
T%(4)=170
T%(5)=85
T%(6)=0

DIM J%,K%,L% AS INTEGER

DLC_SETUP
MAIN_LOOP:
  FOR J%= 1 to 4
    FOR K% = 1 TO 6
      FOR L% = 0 to 60 STEP 4
        B%(L%+J%)=T%(K%)
      NEXT L%
      DLC_SEND_PACKET B%(),64
      PAUSE 500
    NEXT K%
  NEXT J%  
GoTo MAIN_LOOP

Sub DLC_SETUP
  Pin(DLC_TX_PIN)=1
  SetPin DLC_TX_PIN,DOUT  ''IDLE HIGH
End Sub

Sub DLC_SEND_PACKET D%() As INTEGER, N% As INTEGER
  LOCAL STRING S$
  LOCAL INTEGER I%
  S$=CHR$(0)                      ''leading 0 = data to follow
  FOR I% = 1 to N%
    S$=S$+chr$(D%(I%))            ''build up output data
  NEXT I%      
  Pin(DLC_TX_PIN)=0               ''start break
  Pause 1                         ''break of ~38 bits
  Pin(DLC_TX_PIN)=1               ''return to mark
  Pause 1                         ''mark after break
  SerialTx(DLC_TX_PIN,38400,S$)   ''send data
  Pin(DLC_TX_PIN)=1               ''return to idle
End Sub

CSub SerialTx
00000008
00001021 40824800 40024800 0044102b 1440fffd 00000000 03e00008 00000000
27bdffc8 afb40020 3c149d00 8e820000 afb00010 8c500000 8ca30000 00108042
0203001b 006001f4 afb10014 8e820010 00808821 8c840000 afbf0034 afb60028
afb3001c afb20018 00c0b021 24050008 00003021 afbe0030 afb7002c afb50024
0040f809 00008012 8e240000 8e820014 0040f809 24050001 8e240000 8e820024
0040f809 24050006 00409021 8e240000 8e820024 0040f809 24050005 00409821
8e240000 8e820028 0040f809 2610fffb 82c30000 18600027 24110001 00518804
24150001 ae710000 02002021 0411FFC4 00000000 241e0008 24170001 10000009
02d5a021 ae510000 02002021 0017b840 27deffff 0411FFBA 00000000 13c0000d
32f700ff 82820000 02e21024 1440fff5 00000000 ae710000 02002021 0017b840
27deffff 0411FFAE 00000000 17c0fff5 32f700ff ae510000 02002021 0411FFA8
00000000 82c20000 02a2102a 1440ffdd 26b50001 8fbf0034 00001021 00001821
8fbe0030 8fb7002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014
8fb00010 03e00008 27bd0038
End CSub